/*  
 *
 *  JRacer
 *  Created by: Kyle, Aaron, Brad
 *  June 2005 (C)
 *  
 */
 
 // Game Imports
import java.awt.*;
import java.awt.event.*;    
import javax.swing.*;


public class GamePanel extends JPanel implements ActionListener    //GamePanel Class
{  
	
	public static boolean buttons[]=new boolean[17];
	//used to get key input from keypressControl
	KeypressControl KPC=new KeypressControl(this);  
	//gets key input, returns and array of booleans
	//true if a key is being pressed, otherwise false
	public static TileMap TM=new TileMap();
	//is a grid of 25 by 25 pixel tiles
	public static Player P1=new Player(1);  
	public static Player P2=new Player(2);
	//create both players  
	private int time; 
	private int time2;
	//keep track of player's scores
	public Timer T;
	//the timer that runs everything
	public HighScore hs;
	private boolean done;
	public static int level;
	
	//****GAMEPANEL****	
	//runs all the events in the game including
	//initializing the tilemap and players
	//restting players when they move setting trails behind them
	//drawing all graphics
	//restting everything when a player crashes
	//updating player's scores
	//exiting when the game is over	
	public GamePanel() 
	{  
			
		hs = new HighScore();
		int x=hs.getP1Score();
		int y=hs.getP2Score();
		level=5;	
		T=new Timer(1, this);  // ONLY Game Timer
		for(int a=0;a<32;a++){
			for(int b=0;b<24;b++){
				
				
				TM.setTile(a,b,"blank.png");  
				
			}  
		}  
		//set all tiles initially to as blank, a solid black square.
		done=false;
		time=0;
		time2=0;
		
		T.start();  
		
	} 
	
	
	public void actionPerformed(ActionEvent e)
	{ 	
		
		if(done) //when one player has crashed
		{
			try { Thread.sleep(2000); } catch (Exception a) {}
			reset(); //reset everything to play again
		}
		buttons=KPC.getInput();//getting key input from the keypressControl
		
		
		//**player1**
		
		if(P1.getCrash()){  //If player1 crashes set tile to crash image
			TM.setTile(P1.getX(),P1.getY(),"crash.png");
			done=true;
		}  
		
		else //if they haven't crashed
		{  
			if(!P1.getDead()) time = time + 1;//updating score
			
			if(buttons[0]&&!P1.getDead())//if they press the jump
										//button and aren't dead
			{
				P1.jump();//calls jump method in player
				
			}
			
			else { //they didn't crash or jump
				P1.move(); //moves the player one tile 
						//uses players move method to change x and
						//y coordinates
				TM.setTile(P1.getX(),P1.getY(),P1.getCoulor()+P1.getDirection()+".png");  
				//resets the player at the new coordinates
				if(P1.getDirection().equals(P1.getTempDirection()))  
				{
					TM.setTile(P1.getTempX(),P1.getTempY(),P1.getTempDirection()+".png"); 
					//if he's going the same direction put a
					//line tile in that direction behing him 
				}  
				else//he turned 
				{
					TM.setTile(P1.getTempX(),P1.getTempY(),P1.getTempDirection()+P1.getDirection()+".png");	
					//sets the appropriate corner tile
					//using his old and new direction
				}  
			}  
		}
		//**player 2**
		//same as player 1
		
		if(P2.getCrash()){   
			TM.setTile(P2.getX(),P2.getY(),"crash.png");
			done=true;		
		}  
		
		else
		{
			if(!P2.getDead())time2 = time2 + 1;
			
			if(buttons[5]&&!P2.getDead())
			{
				P2.jump();	
			}
			else
			{
				P2.move();   
				TM.setTile(P2.getX(),P2.getY(),P2.getCoulor()+P2.getDirection()+".png"); 
			
				if(P2.getDirection().equals(P2.getTempDirection())) 
				{
					TM.setTile(P2.getTempX(),P2.getTempY(),P2.getTempDirection()+".png");   
				}  
				else 
				{
					TM.setTile(P2.getTempX(),P2.getTempY(),P2.getTempDirection()+P2.getDirection()+".png");	
				}  
			}  
		}
		hs.setScore(time, time2);//updates highscores
		repaint();//paints all the new tiles
    }  
	
	/****PAINT****
	converts the strings stored in the tile map top images, and 
	uses there array index multiplied by 25 - size of each image - 
	as the loscation to display them at
	*/
	public void paint(Graphics g) 
	{       	
       	//***draws every tile in the tilemap***
       	for(int a=0;a<32;a++)
       	{
			for(int b=0;b<24;b++)
			{
				
				g.drawImage(new ImageIcon(TileMap.getTile(a,b)).getImage(),(a*25),(b*25),this);  //Draws game (tile map)
				
			} 
		}  
		requestFocus();  //Lets user give input
		
		//draws players scores and lives on the game screen
		g.setFont(new Font("Serif", Font.BOLD, 20));
		g.setColor(Color.cyan);
		g.setColor(Color.white);
		g.fillRect(0,0,855,20);
		g.setColor(Color.red);
		g.setFont(new Font("Serif", Font.BOLD, 20));
		g.drawString("Player1:   "+time,5,15);
		g.drawString("Player 1 Lives:  "+P1.getLives(),150,15);
		g.setColor(Color.blue);
		g.drawString("Player 2:  "+time2,670,15);
		g.drawString("player2 Lives:   "+ P2.getLives(),425,15);
	}
	
	/***reset***
	resets everything, including
	key input
	tile map
	players - if one is dead sets the difficulty of the computer
			  player based on remaining players score
			- if both are dead print out scores and exit game
			  
	*/
	public void reset()
	{
		buttons=KPC.getInput();
		for(int c=0;c<17;c++) //clearing keypresses so that they
							//don't linger into the start of the
							//next game
		{
			buttons[c]=false;
		}
		
		done=false;
		for(int a=0;a<32;a++){		//reseting all tiles to blank
			for(int b=0;b<24;b++){
				
				
				TM.setTile(a,b,"blank.png"); 
				
			}
			
			
			
			
			
		}  
		if(P1.getDead()) 		//if player 1 is dead, set the
								//difficulty of the computer AI
								//based on player's score
		{
			if(time2<50)level=10;
			else if(time2<100)level=5;
			else if(time2<300)level=3;
			else if(time2<500)level=2;
			else level=1;
		}
		else if(P2.getDead())	// same thing if player 2 is dead
		{
			if(time<50)level=10;
			else if(time<100)level=5;
			else if(time<300)level=3;
			else if(time<500)level=2;
			else level=1;	
		}
		
		System.out.println("player 1 score: " + time);
		System.out.println("player 2 score: " + time2);
		
		P1.setPretty(); //calls player 1 
		P2.setPretty(); //and player 2 reset method
		try { Thread.sleep(1000); } catch (Exception e) {}
		//waits a second before starting new game
		if(P1.getDead()&&P2.getDead())  //if both players are dead
										//print out scores
										//then exit
		{
			System.out.println("+--- Final --- Score ---+");
			System.out.println("|                       |");
			System.out.println("|      Player1: "+time+"       |");
			System.out.println("|                       |");
			System.out.println("|      Player2: "+time2+"       |");
			System.out.println("|                       |");
			System.out.println("+-----------------------+");
		 
			System.exit(0); // exits game entirely
		}
		
	}
}